/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.stats;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.github.fabricators_of_create.porting_lib.util.TierSortingRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.stats.BaseMaterialStats;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class HeadMaterialStats
extends BaseMaterialStats
implements IRepairableMaterialStats {
    public static final MaterialStatsId ID = new MaterialStatsId(TConstruct.getResource("head"));
    public static final HeadMaterialStats DEFAULT = new HeadMaterialStats(1, 1.0f, (class_1832)class_1834.field_8922, 1.0f);
    private static final List<class_2561> DESCRIPTION = ImmutableList.of((Object)ToolStats.DURABILITY.getDescription(), (Object)ToolStats.HARVEST_TIER.getDescription(), (Object)ToolStats.MINING_SPEED.getDescription(), (Object)ToolStats.ATTACK_DAMAGE.getDescription());
    private static final class_2960 WOOD_TIER = new class_2960("wood");
    private final int durability;
    private final float miningSpeed;
    private final class_2960 harvestTier;
    private final float attack;
    private transient class_1832 tier;

    public HeadMaterialStats(int durability, float miningSpeed, class_1832 tier, float attack) {
        this.durability = durability;
        this.miningSpeed = miningSpeed;
        this.harvestTier = Objects.requireNonNull(TierSortingRegistry.getName((class_1832)tier), "Cannot create head material stats with unsorted tier");
        this.tier = tier;
        this.attack = attack;
    }

    public HeadMaterialStats(class_2540 buffer) {
        this.durability = buffer.readInt();
        this.miningSpeed = buffer.readFloat();
        this.harvestTier = buffer.method_10810();
        this.attack = buffer.readFloat();
    }

    public class_2960 getTierId() {
        return this.harvestTier;
    }

    public class_1832 getTier() {
        if (this.tier == null) {
            if (this.harvestTier != null) {
                this.tier = TierSortingRegistry.byName((class_2960)this.harvestTier);
            }
            if (this.tier == null) {
                TConstruct.LOG.error("Failed to find tool tier by name {}", (Object)this.harvestTier);
                this.tier = DEFAULT.getTier();
            }
        }
        return this.tier;
    }

    @Override
    public void encode(class_2540 buffer) {
        buffer.writeInt(this.durability);
        buffer.writeFloat(this.miningSpeed);
        if (this.harvestTier == null) {
            TConstruct.LOG.error("Unset harvest tier for head stats");
            buffer.method_10812(WOOD_TIER);
        } else {
            buffer.method_10812(this.harvestTier);
        }
        buffer.writeFloat(this.attack);
    }

    @Override
    public MaterialStatsId getIdentifier() {
        return ID;
    }

    @Override
    public List<class_2561> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(ToolStats.DURABILITY.formatValue(this.durability));
        info.add(ToolStats.HARVEST_TIER.formatValue(this.getTier()));
        info.add(ToolStats.MINING_SPEED.formatValue(this.miningSpeed));
        info.add(ToolStats.ATTACK_DAMAGE.formatValue(this.attack));
        return info;
    }

    @Override
    public List<class_2561> getLocalizedDescriptions() {
        return DESCRIPTION;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeadMaterialStats that = (HeadMaterialStats)o;
        return this.durability == that.durability && this.miningSpeed == that.miningSpeed && this.attack == that.attack && Objects.equals(this.harvestTier, that.harvestTier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.durability, Float.valueOf(this.miningSpeed), this.harvestTier, Float.valueOf(this.attack));
    }

    public String toString() {
        return "HeadMaterialStats(durability=" + this.getDurability() + ", miningSpeed=" + this.getMiningSpeed() + ", harvestTier=" + this.harvestTier + ", attack=" + this.getAttack() + ", tier=" + this.getTier() + ")";
    }

    @Override
    public int getDurability() {
        return this.durability;
    }

    public float getMiningSpeed() {
        return this.miningSpeed;
    }

    public float getAttack() {
        return this.attack;
    }
}

